from openai import OpenAI
from dotenv import load_dotenv

load_dotenv()

client = OpenAI()

document_path = './pliki/dokument1.txt'
with open(document_path, 'r') as file:
    document = file.read()

    prompt = '''Jesteś dokumentalistą. Twoja rola polega na analizowaniu dokumentów, wyodrębnianiu głównych tematów i generowaniu krótkiego streszczenia. Użyj formatu JSON, aby dostarczyć informacje, w następującej strukturze:
    {
        "tematy": ["temat1", "temat2", "temat3"],
        "podsumowanie": "Streszczenie dokumentów"
    } 
    '''

    response = client.chat.completions.create(
        model="gpt-3.5-turbo",
        messages=[{"role": "user", "content": f'{prompt} Dokument: {document}'}],
        response_format={"type": "json_object"})
    print(response.choices[0].message.content)
